<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type");
    http_response_code(200);

}

    
if($_SERVER['REQUEST_METHOD'] === 'POST'){    
    
    include('../connection/database.php');
    
    $tz = 'Asia/Calcutta';
    $timestamp = time();
    $dt = new DateTime("now", new DateTimeZone($tz));
    $dt->setTimestamp($timestamp); 
    $date = $dt->format('Y/m/d');
    $dates = $dt->format('Y-m-d');
	$time = $dt->format('M d, Y - g:i a');
    
    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);
    
    $file = 'logs.txt';
    file_put_contents($file, $json_data . PHP_EOL, FILE_APPEND | LOCK_EX);
    
    $billingData = $data['billingData'];
    $shippingData = $data['shippingData'];
    $orderData = $data['orderData'];
    $pricing = $data['pricing'];
    $iShip = $data['shipping'];
    
    $orderId = abs(crc32(uniqid()))."".date('GHsi');
    
    $frmData = array('amount'=>$pricing['grandTotal']*100, 'receipt'=>(string)$orderId, 'currency'=>'INR');
    $datas = json_encode($frmData);
    $api_key = "rzp_test_NlXhXr2Ws2mQgF";
    $password = "NicS76luUVyIEGWtvYv6cUpx"; 
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.razorpay.com/v1/orders"); 
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POST, true); 
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERPWD, $api_key.':'.$password);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json', 'Content-Type: application/json'
    ));
    
    $resultss = curl_exec($ch);
    $returnCode= (int) curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    $resp = json_decode($resultss, true);
    $raz_order_id = $resp['id'];
    
    if(isset($data['userId'])){
        $user = $data['userId'];
    }else{
        $user = 'guest';
    }
    
    $items = count($orderData);
    
    $sql1 = "INSERT INTO `billing_address` (`id`, `order_id`, `fname`, `lname`, `adrs1`, `adrs2`, `town`, `state`, `country`, `zip`, `phone`, `email`) VALUES 
    (NULL, '$orderId', '$billingData[bFirstname]', '$billingData[bLastname]', '$billingData[bAdrs1]', '$billingData[bAdrs2]', '$billingData[bTown]', '$billingData[bState]', '$billingData[bContry]', '$billingData[bZip]', '$billingData[bPhone]', '$billingData[bEmail]')"; 
    
    $sql2 = "INSERT INTO `shipping_address` (`id`, `order_id`, `fname`, `lname`, `adrs1`, `adrs2`, `town`, `state`, `country`, `zip`, `phone`, `email`) VALUES 
    (NULL, '$orderId', '$shippingData[sFirstname]', '$shippingData[sLastname]', '$shippingData[sAdrs1]', '$shippingData[sAdrs2]', '$shippingData[sTown]', '$shippingData[sState]', '$shippingData[sContry]', '$shippingData[sZip]', '$shippingData[sPhone]', '$shippingData[sEmail]')"; 
    
    $sql3 = "INSERT INTO `orders` (`id`, `order_id`, `cust_id`, `items`, `sub_total`, `gst`, `discount`, `shipping_charge`, `grand_total`, `status`, `date`, `time`, `raz_id`, `payment_id`, `payment_status`, `shipping`, `notes`, `read_status`) VALUES 
    (NULL, '$orderId', '$user', '$items', '$pricing[subTotal]', '$pricing[gst]', '$pricing[discount]', '$pricing[shippingCharge]', '$pricing[grandTotal]', 'Order Placed', '$date', '$time', '$raz_order_id', 'testing_mode', 'not_paid', '$iShip', '$billingData[orderNotes]', 'no')";
    
    
    $res1 = mysqli_query($db,$sql1);
    
    if($iShip == true ){
      $res2 = mysqli_query($db,$sql2);
    }
    
    $res3 = mysqli_query($db,$sql3);
    
    foreach($orderData as $product){
        $sql4 = "INSERT INTO `order_details` (`id`, `order_id`, `pro_id`, `pro_name`, `weight`, `price`, `gst`, `qty`, `image`) VALUES 
        (NULL, '$orderId', '$product[productId]', '$product[productName]', '$product[productWeight]', '$product[productPrice]', '$product[productGst]', '$product[productQty]', '$product[productImage]')"; 
        
        $res4 = mysqli_query($db,$sql4);
    }
    
    echo json_encode([
        'status' => 'success',
        'orderId' => $orderId,
        'paymentId'=> $raz_order_id
    ]);
    
}else{
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method'
    ]);
}

?>



