<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type");
    http_response_code(200);

}

    
if($_SERVER['REQUEST_METHOD'] === 'POST'){    
    
    include('../../connection/database.php');
    
    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);
    
    $file = 'logs.txt';
    file_put_contents($file, $json_data . PHP_EOL, FILE_APPEND | LOCK_EX);
    
    $orderId = $data['orderId'];
    
    $sql = "SELECT * FROM orders WHERE order_id='$orderId' ";
    $res = mysqli_query($db,$sql);
    $count = mysqli_num_rows($res);
    
    $rawData = [
        "status"=> "success",
        "count"=> $count,
        "orderID"=> $orderId,
        "orderData"=> [],
        "orderDetails"=> [],
        "billingData"=> [],
        "shippingData"=> []
    ];
    
    if($count > 0){
        
        $row = mysqli_fetch_array($res);
        $rawData['orderData'][] = [
            "orderId"=> $row['order_id'],
            "Items"=> $row['items'],
            "subTotal"=> $row['sub_total'],
            "gst"=> $row['gst'],
            "discount"=> $row['discount'],
            "shippingCharge"=> $row['shipping_charge'],
            "grandTotal"=> $row['grand_total'],
            "cutomerId"=> $row['cust_id'],
            "orderStatus"=> $row['status'],
            "razId"=> $row['raz_id'],
            "paymentId"=> $row['payment_id'],
            "paymentStatus"=> $row['payment_status'],
            "date"=> $row['date'],
            "time"=> $row['time'],
            "read"=> $row['read_status'],
        ];
        
        if($row['shipping'] == 'saved'){
            
            $query = "SELECT * FROM address WHERE order_id='$orderId' ";
            $result = mysqli_query($db,$query);
            $rowsAdrs = mysqli_fetch_array($result);
            
            $bAdrs = $rowsAdrs['b_adrs_id'];
            $sAdrs = $rowsAdrs['s_adrs_id'];
            
            $sql1 = "SELECT * FROM billing_address WHERE id='$bAdrs' ";
            $sql2 = "SELECT * FROM shipping_address WHERE id='$sAdrs' ";
        }else{
        
            $sql1 = "SELECT * FROM billing_address WHERE order_id='$orderId' ";
            $sql2 = "SELECT * FROM shipping_address WHERE order_id='$orderId' ";
            
        }
        
        $res1 = mysqli_query($db,$sql1);
        $row1 = mysqli_fetch_array($res1);
        
        $rawData['billingData'] = [
            "fName"=> $row1['fname'],
            "lName"=> $row1['lname'],
            "adrs1"=> $row1['adrs1'],
            "adrs2"=> $row1['adrs2'],
            "town"=> $row1['town'],
            "state"=> $row1['state'],
            "zip"=> $row1['zip'],
            "country"=> $row1['country'],
            "phone"=> $row1['phone'],
            "email"=> $row1['email']
        ];
        
        $res2 = mysqli_query($db,$sql2);
        $shiCount = mysqli_num_rows($res2);
        
        if($row['shipping'] == '1' || $row['shipping'] == 'saved'){
        $row2 = mysqli_fetch_array($res2);
        
            $rawData['shippingData'] = [
                "fName"=> $row2['fname'],
                "lName"=> $row2['lname'],
                "adrs1"=> $row2['adrs1'],
                "adrs2"=> $row2['adrs2'],
                "town"=> $row2['town'],
                "state"=> $row2['state'],
                "zip"=> $row2['zip'],
                "country"=> $row2['country'],
                "phone"=> $row2['phone'],
                "email"=> $row2['email']
            ];
        
        }else{
            $rawData['shippingData'] = [
                "fName"=> $row1['fname'],
                "lName"=> $row1['lname'],
                "adrs1"=> $row1['adrs1'],
                "adrs2"=> $row1['adrs2'],
                "town"=> $row1['town'],
                "state"=> $row1['state'],
                "zip"=> $row1['zip'],
                "country"=> $row1['country'],
                "phone"=> $row1['phone'],
                "email"=> $row1['email']
            ];
        }
        
        
        
        $sql3 = "SELECT * FROM order_details WHERE order_id='$orderId' ";
        $res3 = mysqli_query($db,$sql3);
        $i = 0;
        while($rows = mysqli_fetch_assoc($res3)){
            $rawData['orderDetails'][$i] = [
                "productId"=> $rows['pro_id'],
                "productName"=> $rows['pro_name'],
                "productWeight"=> $rows['weight'],
                "productQty"=> $rows['qty'],
                "productGst"=> $rows['gst'],
                "productPrice"=> $rows['price'],
                "productImage"=> $rows['image'],
            ];
            $i++;
        }
    }
    
    echo json_encode($rawData);
    
}else{
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method',
        'request method'=>$_SERVER['REQUEST_METHOD']
    ]);
}

?>


