<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type");
    http_response_code(200);

}

    
if($_SERVER['REQUEST_METHOD'] === 'POST'){    
    
    include('../../connection/database.php');
    
    $tz = 'Asia/Calcutta';
    $timestamp = time();
    $dt = new DateTime("now", new DateTimeZone($tz));
    $dt->setTimestamp($timestamp); 
    $date = $dt->format('Y/m/d');
    $dates = $dt->format('Y-m-d');
	$time = $dt->format('M d, Y - g:i a');
    
    $json_data = file_get_contents('php://input');
    $data = json_decode($json_data, true);
    
    $file = 'logs.txt';
    file_put_contents($file, $json_data . PHP_EOL, FILE_APPEND | LOCK_EX);
    
    $billingData = $data['billingData'];
    $shippingData = $data['shippingData'];
    $orderData = $data['orderData'];
    $pricing = $data['pricing'];
    $user = $data['userId'];
    
    // $query = "SELECT * FROM billing_address WHERE cust_id='$billingData' ";
    // $result = mysqli_query($db,$query);
    // $bRows = mysqli_fetch_array($result);
    
    // $query1 = "SELECT * FROM shipping_address WHERE cust_id='$shippingData' ";
    // $result1 = mysqli_query($db,$query1);
    // $sRows = mysqli_fetch_array($result1);
    
    $orderId = abs(crc32(uniqid()))."".date('GHsi');
    
    $frmData = array('amount'=>$pricing['grandTotal']*100, 'receipt'=>(string)$orderId, 'currency'=>'INR');
    $datas = json_encode($frmData);
    $api_key = "rzp_test_NlXhXr2Ws2mQgF";
    $password = "NicS76luUVyIEGWtvYv6cUpx"; 
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.razorpay.com/v1/orders"); 
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POST, true); 
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERPWD, $api_key.':'.$password);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json', 'Content-Type: application/json'
    ));
    
    $resultss = curl_exec($ch);
    $returnCode= (int) curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    $resp = json_decode($resultss, true);
    $raz_order_id = $resp['id'];
    
    
    $items = count($orderData);
    
    $sql1 = "INSERT INTO `address` (`cust_id`, `order_id`, `b_adrs_id`, `s_adrs_id`) VALUES ('$user', '$orderId', '$billingData', '$shippingData')";
    
    $sql2 = "INSERT INTO `orders` (`id`, `order_id`, `cust_id`, `items`, `sub_total`, `gst`, `discount`, `shipping_charge`, `grand_total`, `status`, `date`, `time`, `raz_id`, `payment_id`, `payment_status`, `shipping`, `notes`, `read_status`) VALUES 
    (NULL, '$orderId', '$user', '$items', '$pricing[subTotal]', '$pricing[gst]', '$pricing[discount]', '$pricing[shippingCharge]', '$pricing[grandTotal]', 'Order Placed', '$date', '$time', '$raz_order_id', 'testing_mode', 'not_paid', 'saved', '', 'no')";
    
    $res1 = mysqli_query($db,$sql1);
    $res2 = mysqli_query($db,$sql2);
    
    foreach($orderData as $product){
        $sql3 = "INSERT INTO `order_details` (`id`, `order_id`, `pro_id`, `pro_name`, `weight`, `price`, `gst`, `qty`, `image`) VALUES 
        (NULL, '$orderId', '$product[productId]', '$product[productName]', '$product[productWeight]', '$product[productPrice]', '$product[productGst]', '$product[productQty]', '$product[productImage]')"; 
        
        $res3 = mysqli_query($db,$sql3);
    }
    
    echo json_encode([
        'status' => 'success',
        'orderId' => $orderId,
        'paymentId'=> $raz_order_id,
    ]);
    
}else{
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method'
    ]);
}

?>



