<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type");
    http_response_code(200);

}

    
if($_SERVER['REQUEST_METHOD'] === 'GET'){  
    
    include('../connection/database.php');
    
    $sql = "SELECT * FROM combo WHERE deleted='no' ";
    $res = mysqli_query($db,$sql);
    $count = mysqli_num_rows($res);
    
    if($count > 0){
        
        $rawData = [
            "status"=> "success",
            "count"=> $count,
            "data"=> []
        ];
        
        while($rows = mysqli_fetch_assoc($res)){
            $rawData['data'][] = [
                "comboId"=> $rows['id'],
                "comboPack"=> $rows['pack'],
                "comboDes"=> $rows['des'],
                "comboCount"=> $rows['item_count'],
                "comboCategory"=> $rows['category'],
                "comboPrice"=> $rows['price'],
                "comboWeight"=> $rows['weight'],
                "comboImage"=> $rows['image'],
                "comboDate"=> $rows['date']
            ];
        }
        
    }else{
       $rawData = [
            'status' => 'error',
            'message' => 'Email or password not registered with us!',
            'request method'=>$_SERVER['REQUEST_METHOD']
        ];
    }
    
    echo json_encode($rawData);
    
    
}elseif($_SERVER['REQUEST_METHOD'] === 'POST'){
    
    include('../connection/database.php');
    
    $tz = 'Asia/Calcutta';
    $timestamp = time();
    $dt = new DateTime("now", new DateTimeZone($tz));
    $dt->setTimestamp($timestamp); 
    $date = $dt->format('Y/m/d');
    $dates = $dt->format('Y-m-d');
	$time = $dt->format('M d, Y - g:i a');
    
    $targetDirectory = 'images/';
    
    if(isset($_FILES['image']) && $_FILES['image']['error'] == 0){
        $uploadedFileName1 = $_FILES['image']['name'];
        $imageFileType1 = strtolower(pathinfo($uploadedFileName1, PATHINFO_EXTENSION));
        $newFileName1 = uniqid() . '_combo_image.' . $imageFileType1;
        $targetFile1 = $targetDirectory . basename($newFileName1);
    
        // Ensure the target directory exists
        if (!file_exists($targetDirectory)) {
        mkdir($targetDirectory, 0777, true);
        }

        // Move the uploaded file to the target directory
        if (move_uploaded_file($_FILES['image']['tmp_name'], $targetFile1)) {
            // echo "File has been uploaded successfully.";
        } else {
            $newFileName1 = 'no_img.webp';
        }
    }else{
        $newFileName1 = 'no_img.webp';
    }
	
	$sql = "INSERT INTO `combo` ( `pack`, `des`, `item_count`, `category`, `weight`, `price`, `image`, `deleted`, `date`) VALUES 
    ('$_POST[name]', '', '$_POST[count]', '', '$_POST[weight]', '$_POST[price]', '$newFileName1', 'no', '$date')";
    
    $res = mysqli_query($db,$sql);
    
    
    if($res){
        
        $rawData = [
            "status"=> "success",
            "message"=> 'combo item added!',
        ];
        
    }else{
       $rawData = [
            'status' => 'error',
            'message' => 'Email or password not registered with us!',
            'request method'=>$_SERVER['REQUEST_METHOD']
        ];
    }
    
    echo json_encode($rawData);
    
    
}else{
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method',
        'request method'=>$_SERVER['REQUEST_METHOD']
    ]);
}

?>




